//*************************************************************
//***************       Autor: R. Müller        ***************
//***************       Datum: 20.06.2020       ***************
//***************       IOT-TEMPERATUR          ***************
//*************************************************************

//Bibliotheken für die Internetverbindung einbinden
#include <WiFi.h>
#include <HTTPClient.h>

//Bibliotheken für den Dallas Sensor einbinden
#include <OneWire.h>
#include <DallasTemperature.h>


//Jetzt wird definiert, dass wir den Daten-Bus des Dallas an Pin 32 anschließen
#define ONE_WIRE_BUS 32

//Anschließend wird mit dem Wert ein Objekt oneWire der Klasse OneWire erzeugt
OneWire oneWire(ONE_WIRE_BUS);

//Jetzt wird ein Objekt sensors der Klasse DallasTemperatur mit dem Datenbus gebildet
DallasTemperature sensors(&oneWire);

//Temperatur und Luftfeuchte Variablen die später beschrieben und an Thingspeak gesendet werden
String temperatur = "";
//String luftfeuchte = "";  Erweiterung der Luftfeuchte


//Hier musst du den WLAN Name des Netzwerkes und das jeweilige Passwort ergänzen
const char* ssid = "GEBE_HIER_DEIN_NETZWERKNAME_EIN";
const char* password = "GEBE_HIER_DEIN_NETZWERK_PASSWORT_EIN!";

//Dies ist der Server Name für Thingspeak
const char* serverName = "http://api.thingspeak.com/update";

//Hier musst du deinen API Key ergänzen
String apiKey = "GEBE_HIER_DEIN_API_KEY_EIN";


//Dies ist der Zähler, wie oft der ESP32 schon neu hochgefahren (aufgewacht) ist (Stichwort DEEP-Sleep)
RTC_DATA_ATTR int bootCount = 0;


//Umrechnung von µs auf s (Sekunden) weil der Deep Sleep in µs eingestellt wird
int umrechnung_us_zu_s = 1000000;

//Intervall in Sekunden wo der ESP neue Werte schicken soll und in den Stromsparmodus gehen soll ("schlafen")
int schlafzeit_in_s = 15;

//Die 15s sollte nicht unterschritten werden, da ThingSpeak bei den kostenlosen Profilen maximal alle 15s
//einen Wert empfängt. Bei einer längeren Unterschreitung kannst du von ThingSpeak ausgeschlossen werden


//Methode um Temperatur zu lesen
String readDallasTemperature()
{
  //Sensor wird auf eine Abfrage vorbereitet
  sensors.requestTemperatures(); 
  
  // Lese Temperatur in Celsius (default)
  float temperatur = sensors.getTempCByIndex(0); //By Index, da auch mehrer Sensoren auf dem Bus sein können
  // Lese Temperatur in Fahrenheit:
  // float t = sensors.getTempFByIndex(0);
  // Wenn nichts gelesen werden kann:
  if (isnan(temperatur))
  {    
    Serial.println("Es konnte keine Temperatur von dem DS18B20-Sensor empfangen werden!");
    return "--";
  }
  else //Wenn Wert gelesen wurde
  {
    Serial.println("Die Temperatur beträgt:");
    Serial.print(temperatur);
    Serial.println("˚C");
    return String(temperatur); //Es wird die Temperatur als String zurückgegeben
  }
}


void setup()  //Dies wird jedes Mal wenn des ESP 32 "aufwacht" einmalig ausgeführt
{
  //Der Serielle Monitor (oben rechts das Symbol mit der Lupe) wird auf eine Bound-Rate von 115200 eingestellt
  Serial.begin(115200);

  ++bootCount; //Die Variable zum Zählen wie oft gebootet wurde eins hochzählen
  Serial.println("Boot number: " + String(bootCount));

  //Der Dallas Sensor wird initalisieren
  sensors.begin();

  //Jetzt wird sich mit dem Wlan verbunden
  WiFi.begin(ssid, password);
  Serial.print("Verbinden mit ");
  Serial.println(ssid);
  delay(50);
  int counter = 0;  //Zähler für Verbindungsaufbau
  while(WiFi.status() != WL_CONNECTED)  //Ausführen solange nicht verbunden
  {
    counter++;
    delay(100);
    Serial.print(".");
    if(counter >= 5)  //Wenn mehr als fünfmal die Verbindung nicht aufgebaut wurde: neu verbinden
    {
      counter = 0;
      WiFi.disconnect();
      delay(50);
      WiFi.begin(ssid, password);
    }
  }
  Serial.println("");
  Serial.print("Erfolgreich verbunden mit der IP-Adresse: ");
  Serial.println(WiFi.localIP());

  //Daten erfassen
  temperatur = readDallasTemperature(); //aktuelle Temperatur lesen und abspeichern

  //Senden der Daten an Thingspeak
  if(WiFi.status() == WL_CONNECTED) //Wenn die WiFi Verbindung noch steht dann führe folgendes aus
  {
    HTTPClient http; //neues Objekt http der Klasse HTTPClient
    
    http.begin(serverName); //Die oben initialisierte Domain "serverName" wird an http übergeben
    
    // Content-Type Header (nicht ändern)
    http.addHeader("Content-Type", "application/x-www-form-urlencoded");
    
    //Daten die gesendet werden einfügen                                     // Erweiterung durch Luftfeuchtigkeit:
    String httpRequestData = "api_key=" + apiKey + "&field1=" + temperatur;  // + "&field2=" + luftfeuchte;
    //Daten senden
    int httpResponseCode = http.POST(httpRequestData);
   
    Serial.print("HTTP Response (Antwort) code: ");
    Serial.println(httpResponseCode); //Gibt den HTTP Antwort Code zurück, wenn alles gut ist: "200"
      
    //Löscht das http Objekt wieder
    http.end();
  }
  else 
  {
    Serial.println("WiFi-Verbindung getrennt!"); //Falls die WiFi Verbindung getrennt wurde
    Serial.println(WiFi.status());
  }

  Serial.println("Tiefschlaf...");
  esp_sleep_enable_timer_wakeup( umrechnung_us_zu_s * schlafzeit_in_s ); //Deep Sleep mit Timer initialisieren
  delay(100);
  esp_deep_sleep_start(); //ESP geht hier in den Stromsparmodus und wacht in schlafzeit_in_s Sekunden wieder auf

  Serial.println("Dieser Text ist total unnötig, da er niemals ausgegeben wird.");
}

void loop()  //Nur zur Vollständigkeit, weil beim Deep Sleep nur die setup() Methode aufgerufen wird
{

}
