//*************************************************************
//***************       Autor: T. Happe         ***************
//***************       Datum: 30.09.2020       ***************
//***************       SmartHome               ***************
//*************************************************************


#include <WiFi.h>
#include <HTTPClient.h>

//Hier werden die ganzen verwendeten Pins festgelegt.
//Sollen andere Pins benutzt werden reicht es hier lediglich andere Zahlen einzusetzen.
#define BUTTON_MODUS 26
#define BUTTON_TOGGLE 25
#define LDR_PIN 34
#define LED_FEEDBACK 32

//Wert, bei welchem zwischen "Dunkel" bzw. "Hell" unterschieden wird
#define LDR_GRENZE 1000


const char* ssid = "Netzwerk SSID" ;     //Netzwerk SSID mit dem Namen des eigenen WLAN-Neztwerkes ersetzen
const char* password = "WLAN-PASSWORT";  //WLAN-PASSWORT mit dem Passwort des eigenen WLAN-Neztwerkes ersetzen

//Hier werden die Links für die jeweiligen Events aus IFTTT eingefügt (s. Anleitung "IFTTT - API Zugangscode")
const char* link_an = "https://maker.ifttt.com/trigger/Steckdose%AN/with/key/cz9J7dsRjakvxg9cMcoi4h";
const char* link_aus = "https://maker.ifttt.com/trigger/Steckdose%AUS/with/key/cz9J7dsRjakvxg9cMcoi4h";
const char* link_toggle = "https://maker.ifttt.com/trigger/TOGGLE/with/key/cz9J7dsRjakvxg9cMcoi4h";

//Diese globalen Variablen sind für den Programmablauf notwendig
bool vorher = false;    //gibt an, ob die Steckdose zuletzt ein oder aus geschaltet wurde
bool automatik = true;  //gibt an, ob der manuelle oder der automatische Modus genutzt werden soll
bool manuellvorher = false; //damit die variable "vorher" bei dem ersten Wechsel auf den Automatikmodus zurückgesetzt wird


void setup()
{
  //pinModes aller oben festgelegten Pins wird initialisiert
  pinMode(BUTTON_TOGGLE, INPUT);
  pinMode(BUTTON_MODUS, INPUT);
  pinMode(LDR_PIN, INPUT);
  pinMode(LED_FEEDBACK, OUTPUT);

  //Initialisierung der Seriellen Schnittstelle und des WLAN's
  Serial.begin(9600);
  WiFi.begin(ssid, password);

  //Solange das WLAN nicht verbunden ist wird gewartet
  while (WiFi.status() != WL_CONNECTED)
  {
    delay(5000);
    Serial.print(".");
  }

  //Nachricht im Seriellen Monitor, dass die WLAN Verbindung hergestellt wurde
  Serial.println("");
  Serial.print("Verbindung zu WLAN-Netzwerk Hergestellt mit IP-Adresse: ");
  Serial.println(WiFi.localIP());
  delay(5000);
}



void loop()
{
  delay(100);

  //Falls das WLAN nicht verbunden ist, wird nur eine Fehlermeldung ausgegeben und keine Web-Requests werden verschickt
  if (WiFi.status() == WL_CONNECTED)
  {
    //Abfrage für den Wechsel zwischen beiden Modi
    if ((digitalRead(BUTTON_MODUS) == HIGH) && automatik)
    {
      digitalWrite(LED_FEEDBACK, HIGH);
      automatik = false;
      Serial.println("Manueller Modus wurde aktiviert");
      delay(1000);
    }
    else if ((digitalRead(BUTTON_MODUS) == HIGH) && ( !automatik)) //else if sorgt dafür dass nur einer der beiden Blöcke ausgeführt wird -> verhindert, dass sofort danach wieder umgeschaltet wird
    {
      digitalWrite(LED_FEEDBACK, LOW);
      automatik = true;
      Serial.println("Automatischer Modus wurde aktiviert");
      delay(1000);
    }

    //Aufruf der Funktion des gerade aktiven Modus
    if (automatik)
    {
      autom();
    }
    else
    {
      man();
    }
  }
  else
  {
    Serial.println("WLAN NICHT VERBUNDEN!");//Fehlermeldung falls WLAN nicht verbunden ist
  }
}

//Um das Programm übersichtlicher zu gestalten wurden der automatische/manuelle Modus in einzelne Funktionen unterteilt
void autom()
{
  //Wird nach Wechsel des Modus ausgeführt
  if (manuellvorher)
  {
    manuellvorher = false;
    vorher = false;
    digitalWrite(LED_FEEDBACK, LOW);
  }

  //Wert des LDRs wird als true(dunkel) und false(hell) zusammengefasst
  bool ldr = false;
  if (analogRead(LDR_PIN) < LDR_GRENZE)
  {
    ldr = true;
  }
  else
  {
    ldr = false;
  }


  if (ldr && !vorher) //anschalten
  {
    HTTPClient http;
    Serial.println("Helligkeit liegt unter Grenzwert");
    http.begin(link_an); //http-client wird mit dem Link für das an-event gestartet
    int httpCode = http.GET(); //http get-Anfrage wird abgeschickt
    Serial.println("HTTP-Code: ");  //Code, der als Antwort gesendet wird, wird ausgegeben
    Serial.print(httpCode);
    Serial.print("\n");
    vorher = true;
  }
  else if (!ldr && vorher) //ausschalten
  {
    HTTPClient http;
    Serial.println("Helligkeit liegt über Grenzwert");
    http.begin(link_aus);
    int httpCode = http.GET();
    Serial.println("HTTP-Code: ");
    Serial.print(httpCode);
    Serial.print("\n");
    vorher = false;
  }
}

//Manueller Modus
void man()
{
  digitalWrite(LED_FEEDBACK, HIGH);
  manuellvorher = true;

  if (digitalRead(BUTTON_TOGGLE) == HIGH)
  {
    HTTPClient http;
    http.begin(link_toggle);
    int httpCode = http.GET();
    Serial.println("HTTP-Code: ");
    Serial.print(httpCode);
    Serial.print("\n");
  }
}
